import sys
import numpy as np
import pandas as pd
import argparse
parser = argparse.ArgumentParser()
parser.add_argument("-f","--file", help="file",type=str)
parser.add_argument("-c","--column", help="column (1)",default=1,type=int)
parser.add_argument("-o","--outfile",help="file to save output, otherwise prints to screen",type=str)
args = parser.parse_args()

file = args.file
if args.outfile is not None:
    outfile = open(args.outfile,'w')
else:
    outfile = sys.stdout 
col = args.column    
this_data = pd.read_csv(file, sep="\s+", header=None)[col-1]
size = int(len(this_data)/5)
list_data = np.split(this_data,[size,2*size,3*size,4*size,len(this_data)])
list_data.pop()
list_mean = [np.mean(i) for i in list_data]
print("new error bar:",np.std(list_mean))